<?php
/**
 * Bulk Converter Page Template.
 *
 * @package WP_WebP_Optimizer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check user capabilities
if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'Mak8it.com' ) );
}

// Load required classes
require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-bulk-processor.php';
require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-stats.php';

$processor = new WP_WebP_Optimizer_Bulk_Processor();
$stats_class = new WP_WebP_Optimizer_Stats();
$stats = WP_WebP_Optimizer_Stats::get_stats();

// Get unconverted images count
$unconverted_images = $processor->get_unconverted_images();
$unconverted_count = count( $unconverted_images );

// Get conversion status
$conversion_status = get_option( 'wp_webp_conversion_status', 'inactive' );
$conversion_progress = get_option( 'wp_webp_conversion_progress', array() );
?>

<div class="wrap webp-bulk-converter-wrap">
	<h1><?php esc_html_e( 'Bulk WebP Converter', 'small-image' ); ?></h1>

	<div class="webp-bulk-content">
		<!-- Statistics Overview -->
		<div class="webp-stats-cards">
			<div class="stat-card">
				<div class="stat-icon">
					<span class="dashicons dashicons-images-alt2"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $stats['total_images'] ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Total Images', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card success">
				<div class="stat-icon">
					<span class="dashicons dashicons-yes-alt"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $stats['converted_images'] ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Converted', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card warning">
				<div class="stat-icon">
					<span class="dashicons dashicons-clock"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $unconverted_count ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Pending', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card info">
				<div class="stat-icon">
					<span class="dashicons dashicons-database"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( WP_WebP_Optimizer_Stats::get_formatted_space_saved() ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Space Saved', 'Mak8it.com' ); ?></div>
				</div>
			</div>
		</div>

		<!-- Main Converter Section -->
		<div class="webp-converter-main">
			<div class="webp-converter-card">
				<h2><?php esc_html_e( 'Bulk Conversion', 'Mak8it.com' ); ?></h2>

				<?php if ( $unconverted_count > 0 ) : ?>
					<div class="conversion-info">
						<p class="info-message">
							<span class="dashicons dashicons-info"></span>
							<?php
							printf(
								/* translators: %d: number of images */
								esc_html__( 'Found %d images ready for WebP conversion.', 'Mak8it.com' ),
								esc_html( $unconverted_count )
							);
							?>
						</p>
					</div>

					<!-- Filters Section -->
					<div class="bulk-filters">
						<div class="filters-header">
							<div class="filters-title">
								<span class="dashicons dashicons-filter"></span>
								<h3><?php esc_html_e( 'Filter Options', 'Mak8it.com' ); ?></h3>
								<span class="filters-badge"><?php esc_html_e( 'Optional', 'Mak8it.com' ); ?></span>
							</div>
							<button type="button" id="btn-toggle-filters" class="button button-small">
								<span class="dashicons dashicons-arrow-down-alt2"></span>
								<span class="toggle-text"><?php esc_html_e( 'Show Filters', 'Mak8it.com' ); ?></span>
							</button>
						</div>

						<div id="filters-content" class="filters-content" style="display: none;">
							<div class="filter-grid">
								<!-- Image Format Filter -->
								<div class="filter-card">
									<div class="filter-card-header">
										<span class="dashicons dashicons-format-image"></span>
										<label for="filter-format" class="filter-label">
											<?php esc_html_e( 'Image Format', 'Mak8it.com' ); ?>
										</label>
									</div>
									<div class="filter-card-body">
										<select id="filter-format" class="filter-select">
											<option value="all"><?php esc_html_e( 'All Formats (JPEG & PNG)', 'Mak8it.com' ); ?></option>
											<option value="jpeg"><?php esc_html_e( 'JPEG Only', 'Mak8it.com' ); ?></option>
											<option value="png"><?php esc_html_e( 'PNG Only', 'Mak8it.com' ); ?></option>
										</select>
										<p class="filter-hint"><?php esc_html_e( 'Choose which image formats to convert', 'Mak8it.com' ); ?></p>
									</div>
								</div>

								<!-- Date Range Filter -->
								<div class="filter-card">
									<div class="filter-card-header">
										<span class="dashicons dashicons-calendar-alt"></span>
										<label class="filter-label">
											<?php esc_html_e( 'Upload Date Range', 'Mak8it.com' ); ?>
										</label>
									</div>
									<div class="filter-card-body">
										<div class="date-range-group">
											<div class="date-input-wrapper">
												<label for="filter-date-from" class="date-label">
													<span class="dashicons dashicons-arrow-right-alt"></span>
													<?php esc_html_e( 'From', 'Mak8it.com' ); ?>
												</label>
												<input type="date" id="filter-date-from" class="filter-date">
											</div>
											<div class="date-separator">
												<span class="dashicons dashicons-arrow-right-alt"></span>
											</div>
											<div class="date-input-wrapper">
												<label for="filter-date-to" class="date-label">
													<span class="dashicons dashicons-arrow-right-alt"></span>
													<?php esc_html_e( 'To', 'Mak8it.com' ); ?>
												</label>
												<input type="date" id="filter-date-to" class="filter-date">
											</div>
										</div>
										<p class="filter-hint"><?php esc_html_e( 'Filter images by upload date', 'Mak8it.com' ); ?></p>
									</div>
								</div>

								<!-- Image Size Filter -->
								<div class="filter-card">
									<div class="filter-card-header">
										<span class="dashicons dashicons-admin-generic"></span>
										<label for="filter-size" class="filter-label">
											<?php esc_html_e( 'Image Size', 'Mak8it.com' ); ?>
										</label>
									</div>
									<div class="filter-card-body">
										<select id="filter-size" class="filter-select">
											<option value="all"><?php esc_html_e( 'All Sizes', 'Mak8it.com' ); ?></option>
											<option value="full"><?php esc_html_e( 'Full Size Only', 'Mak8it.com' ); ?></option>
											<option value="large"><?php esc_html_e( 'Large & Full', 'Mak8it.com' ); ?></option>
											<option value="medium"><?php esc_html_e( 'Medium & Above', 'Mak8it.com' ); ?></option>
										</select>
										<p class="filter-hint"><?php esc_html_e( 'Filter by WordPress image size', 'Mak8it.com' ); ?></p>
									</div>
								</div>
							</div>

							<div class="filters-footer">
								<button type="button" id="btn-reset-filters" class="button button-link">
									<span class="dashicons dashicons-update"></span>
									<?php esc_html_e( 'Reset Filters', 'Mak8it.com' ); ?>
								</button>
								<div class="filter-summary">
									<span id="filter-summary-text"><?php esc_html_e( 'No filters applied', 'Mak8it.com' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<!-- Control Buttons -->
					<div class="conversion-controls">
						<button id="btn-start-conversion" class="button button-primary button-hero">
							<span class="dashicons dashicons-controls-play"></span>
							<?php esc_html_e( 'Start Bulk Conversion', 'Mak8it.com' ); ?>
						</button>
						
						<button id="btn-pause-conversion" class="button button-secondary" style="display: none;">
							<span class="dashicons dashicons-controls-pause"></span>
							<?php esc_html_e( 'Pause', 'Mak8it.com' ); ?>
						</button>
						
						<button id="btn-resume-conversion" class="button button-secondary" style="display: none;">
							<span class="dashicons dashicons-controls-play"></span>
							<?php esc_html_e( 'Resume', 'Mak8it.com' ); ?>
						</button>
						
						<button id="btn-stop-conversion" class="button button-link-delete" style="display: none;">
							<span class="dashicons dashicons-no"></span>
							<?php esc_html_e( 'Stop', 'Mak8it.com' ); ?>
						</button>
					</div>

					<!-- Progress Section -->
					<div id="conversion-progress" class="conversion-progress" style="display: none;">
						<h3><?php esc_html_e( 'Conversion Progress', 'Mak8it.com' ); ?></h3>
						
						<div class="progress-bar-container">
							<div class="progress-bar">
								<div id="progress-bar-fill" class="progress-bar-fill" style="width: 0%;">
									<span id="progress-percentage">0%</span>
								</div>
							</div>
						</div>

						<div class="progress-stats">
							<div class="progress-stat">
								<strong><?php esc_html_e( 'Processed:', 'Mak8it.com' ); ?></strong>
								<span id="stat-processed">0</span> / <span id="stat-total">0</span>
							</div>
							<div class="progress-stat success">
								<strong><?php esc_html_e( 'Successful:', 'Mak8it.com' ); ?></strong>
								<span id="stat-successful">0</span>
							</div>
							<div class="progress-stat" id="stat-failed-container">
								<strong><?php esc_html_e( 'Failed:', 'small-image' ); ?></strong>
								<span id="stat-failed">0</span>
							</div>
							<div class="progress-stat warning">
								<strong><?php esc_html_e( 'Skipped:', 'Mak8it.com' ); ?></strong>
								<span id="stat-skipped">0</span>
							</div>
							<div class="progress-stat">
								<strong><?php esc_html_e( 'Estimated Time:', 'Mak8it.com' ); ?></strong>
								<span id="stat-estimated-time">--</span>
							</div>
						</div>

						<div id="conversion-status" class="conversion-status"></div>
					</div>

					<!-- Conversion Log -->


				<?php else : ?>
					<div class="no-images-message">
						<span class="dashicons dashicons-yes-alt"></span>
						<h3><?php esc_html_e( 'All Images Converted!', 'Mak8it.com' ); ?></h3>
						<p><?php esc_html_e( 'All your images have already been converted to WebP format.', 'Mak8it.com' ); ?></p>
						<p>
							<a href="<?php echo esc_url( admin_url( 'upload.php' ) ); ?>" class="button button-primary">
								<?php esc_html_e( 'View Media Library', 'Mak8it.com' ); ?>
							</a>
						</p>
					</div>
				<?php endif; ?>
			</div>

			<!-- Recent Conversions Sidebar -->
			<div class="webp-converter-sidebar">
				<div class="sidebar-card">
					<h3><?php esc_html_e( 'Recent Conversions', 'Mak8it.com' ); ?></h3>
					<?php
					$recent = WP_WebP_Optimizer_Stats::get_recent_conversions( 5 );
					if ( ! empty( $recent ) ) :
						?>
						<ul class="recent-conversions-list">
							<?php foreach ( $recent as $conversion ) : ?>
								<li>
									<div class="conversion-title">
										<?php echo esc_html( $conversion['post_title'] ); ?>
									</div>
									<div class="conversion-meta">
										<?php
										$original_size = isset( $conversion['original_size'] ) ? intval( $conversion['original_size'] ) : 0;
										$new_size = isset( $conversion['new_size'] ) ? intval( $conversion['new_size'] ) : 0;
										$savings = $original_size > 0 ? round( ( 1 - ( $new_size / $original_size ) ) * 100, 1 ) : 0;
										
										printf(
											/* translators: %s: savings percentage */
											esc_html__( 'Saved %s%%', 'Mak8it.com' ),
											esc_html( $savings )
										);
										?>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					<?php else : ?>
						<p class="no-recent"><?php esc_html_e( 'No recent conversions', 'Mak8it.com' ); ?></p>
					<?php endif; ?>
				</div>

				<div class="sidebar-card">
					<h3><?php esc_html_e( 'Quick Stats', 'Mak8it.com' ); ?></h3>
					<ul class="quick-stats-list">
						<li>
							<strong><?php esc_html_e( 'Average Compression:', 'Mak8it.com' ); ?></strong>
							<span><?php echo esc_html( number_format( $stats['average_compression'], 1 ) ); ?>%</span>
						</li>
						<li>
							<strong><?php esc_html_e( 'Total Conversions:', 'Mak8it.com' ); ?></strong>
							<span><?php echo esc_html( number_format( $stats['successful_conversions'] ) ); ?></span>
						</li>
					</ul>
				</div>

				<div class="sidebar-card info-card">
					<h3><?php esc_html_e( 'How It Works', 'Mak8it.com' ); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Click "Start Bulk Conversion"', 'Mak8it.com' ); ?></li>
						<li><?php esc_html_e( 'Images are processed in batches of 20', 'Mak8it.com' ); ?></li>
						<li><?php esc_html_e( 'You can pause or stop anytime', 'Mak8it.com' ); ?></li>
						<li><?php esc_html_e( 'Original files are kept by default', 'Mak8it.com' ); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>
</div>

